/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.client.screen.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.technicalitiesmc.lib.client.screen.widget.SimpleWidget;
import com.technicalitiesmc.lib.util.TooltipProvider;
import com.technicalitiesmc.lib.util.value.Reference;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;

public class EnumSelectorWidget<E extends Enum<E>>
extends SimpleWidget {
    private final int u;
    private final int v;
    private final Reference<E> reference;
    private final List<E> values;
    private final E defaultValue;
    @Nullable
    private final Function<E, TooltipProvider> tooltipProvider;

    public EnumSelectorWidget(int x, int y, int width, int height, int u, int v, BooleanSupplier enabled, Reference<E> reference, List<E> values, E defaultValue, @Nullable Function<E, TooltipProvider> tooltipProvider) {
        super(x, y, width, height, enabled);
        this.u = u;
        this.v = v;
        this.reference = reference;
        this.values = values;
        this.defaultValue = defaultValue;
        this.tooltipProvider = tooltipProvider;
    }

    @Override
    public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int index = this.values.indexOf(this.reference.get());
        this.m_93228_(poseStack, 0, 0, this.u + index * this.size().y(), this.v, this.size().x(), this.size().y());
    }

    @Override
    public void onClicked(double x, double y, int button) {
        switch (button) {
            case 0: 
            case 1: {
                this.cycle(button == 0);
                break;
            }
            case 2: {
                this.reference.set(this.defaultValue);
                break;
            }
            default: {
                return;
            }
        }
        this.playClickSound();
    }

    @Override
    public boolean onMouseScrolled(double x, double y, double amount) {
        this.cycle(amount > 0.0);
        this.playClickSound(0.8f, 0.2f);
        return true;
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<Component> tooltip) {
        TooltipProvider tooltipEnabled;
        if (this.tooltipProvider != null && (tooltipEnabled = this.tooltipProvider.apply((Enum)this.reference.get())) != null) {
            tooltipEnabled.addTooltip(tooltip);
        }
    }

    private void cycle(boolean forward) {
        Enum value = (Enum)this.reference.get();
        if (value != null) {
            int idx = this.values.indexOf(value);
            int total = this.values.size();
            int newIdx = (idx + (forward ? 1 : total - 1)) % total;
            this.reference.set((Enum)this.values.get(newIdx));
        }
    }
}

